<?

###################################################################################################
# Copyright (c) 2006 Aastra Telecom US, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#    1. Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#    2. Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#    3. The name of Aastra Telecom US, Inc. may not be used to endorse or promote
#       products derived from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY AASTRA TELECOM US, INC. ``AS IS'' AND ANY EXPRESS
# OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
# OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
# IN NO EVENT SHALL AASTRA TELECOM US, INC. BE LIABLE FOR ANY DIRECT, INDIRECT, 
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
# OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
# LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
# OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
###################################################################################################
# Asterisk DND for Aastra SIP Phones R1.4.1 or better
#
# php source code
#####################################################################

include (dirname(__FILE__)."/phpagi/misc.php");
include (dirname(__FILE__)."/phpagi/phpagi-asmanager.php");

#####################################################################
# Aastra_decode_HTTP_header
#
# Returns an array
#   0 Phone Type
#   1 Phone MAC Address
#   2 Phone firmware version
#####################################################################

function Aastra_decode_HTTP_header()
{
$user_agent=$_SERVER["HTTP_USER_AGENT"];
if(stristr($user_agent,"Aastra"))
	{
	$value=preg_split("/ MAC:/",$user_agent);
	$fin=preg_split("/ /",$value[1]);
	$value[1]=preg_replace("/\-/","",$fin[0]);
	$value[2]=preg_replace("/V:/","",$fin[1]);
	}
else
	{
	$value[0]="MSIE";
	$value[1]="NA";
	$value[2]="NA";
	}

return($value);
}

#####################################################################
# Global parameters
#####################################################################
$Server = "http://$SERVER_ADDR".$_SERVER['SCRIPT_NAME'];
$dnd=0;

# Retrieve parameters
$user=$_GET['user'];
$action=$_GET['action'];
$status=$_GET['status'];

# Force default action
if($action=="") $action="change";

# Get header info
$header=Aastra_decode_HTTP_header();

# Get current value only if action is change or update
if(($action=="change") || ($action=="update"))
	{
	# Connect to AGI
	$as = new AGI_AsteriskManager();
	$res = $as->connect();

	#DND GET
	$res = $as->Command('database get DND '.$user);
	$line=split("\n", $res['data']);
	$value=split(" ", $line[0]);
	if($value[1]=="YES") $dnd=1;
	if($dnd==0)
		{
		$value=split(" ", $line[1]);
		if($value[1]=="YES") $dnd=1;
		}

	# CHANGE CURRENT VALUE
	if($action=="change")
		{
		# change DND status
		if($dnd==0) 
			{
			$res = $as->Command('database put DND '.$user.' YES');
			$dnd=1;
			}
		else 
			{
			$res = $as->Command('database del DND '.$user);
			$dnd=0;
			}
		}

	# Disconnect properly	
	$as->disconnect();
	}

# Setup header type
header("Content-Type: text/xml");

# Update action
if($action=="update")
	{
	$output = "<AastraIPPhoneExecute>\n";
	$output .= "<ExecuteItem URI=\"".$Server."?action=msg&amp;status=".$status."\"/>\n";
	$output .= "</AastraIPPhoneExecute>\n";
	}

# Update message
if($action=="msg")
	{
	$output = "<AastraIPPhoneStatus Beep=\"yes\">\n";
	$output .= "<Session>CFDND12345</Session>\n";
	if ($status==1) $output .= "<Message index=\"0\">DND activated</Message>\n";
	else $output .= "<Message index=\"0\"></Message>\n";
	$output .= "</AastraIPPhoneStatus>\n";
	}

# Action=change
if($action=="change")
	{
	switch($header[0])
		{
		case "Aastra9112i":
		case "Aastra9133i":
			$output = "<AastraIPPhoneStatus Beep=\"yes\">\n";
			$output .= "<Session>CFDND12345</Session>\n";
			if ($dnd==1) $output .= "<Message index=\"0\">DND activated</Message>\n";
			else $output .= "<Message index=\"0\"></Message>\n";
			$output .= "</AastraIPPhoneStatus>\n";
			break;

		default:
			$output = "<AastraIPPhoneTextScreen destroyOnExit=\"yes\">\n";
			$output .= "<Title></Title>\n";
			if ($dnd==0) $output .= "<Text>DND deactivated.</Text>\n";
			else $output .= "<Text>DND activated.</Text>\n";
			$output .= "<SoftKey index=\"6\">\n";
			$output .= "<Label>Done</Label>\n";
			$output .= "<URI>".$Server."?action=update&amp;status=".$dnd."</URI>\n";
			$output .= "</SoftKey>\n";
			$output .= "</AastraIPPhoneTextScreen>\n";
			break;
		}
	}

header("Content-Length: ".strlen($output));
echo $output;
?>
